
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Gamepack / Main"
	SimpleWait ( )
#ENDIF

Declare Sub Gamepack_Main ( Gamepack_Data ( Any ) As Gamepack_Type, Gamepack As Gamepack_Main_Type )

Declare Sub Gamepack_Create ( Gamepack_Data As Gamepack_Type, Gamepack As Gamepack_Main_Type )

Declare Sub Gamepack_Icon_Create ( Gamepack_Data As Gamepack_Type )

Declare Sub Gamepack_Selected_Create ( Gamepack_Data As Gamepack_Type )

Declare Sub Multi_Gamepack_Menu_Destroy ( Gamepack_Data ( Any ) As Gamepack_Type )

Declare Sub Multi_Gamepack_Menu_Create ( Gamepack_Data ( Any ) As Gamepack_Type )

Declare Sub Gamepacks_Prune ( Gamepacks ( Any ) As String, Gamepack_Data ( Any ) As Gamepack_Type )

Declare Sub Gamepack_Render ( Gamepack_Data ( Any ) As Gamepack_Type )

Declare Sub Multi_Gamepack_Create ( Gamepack_Data ( Any ) As Gamepack_Type )

Declare Sub Gamepack_Menu ( Gamepack_Data ( Any ) As Gamepack_Type )

Sub Gamepack_Main ( Gamepack_Data ( Any ) As Gamepack_Type, Gamepack As Gamepack_Main_Type )

	If Len ( CMD ) > 0 Then
		
		If Is_Dir ( Gamepack.Root & CMD & "\Assets" ) <> 0 Then
			
			Gamepack.Pack = CMD
			Exit Sub
			
		End If
		
	End If

	Multi_Gamepack_Menu_Destroy ( Gamepack_Data ( ) )

	Multi_Gamepack_Create ( Gamepack_Data ( ) )
	
	/' [ !!! Very Broken ] Gamepack_Menu ( Gamepack_Data ( ) ) '/

End Sub

Sub Gamepack_Create ( Gamepack_Data As Gamepack_Type, Gamepack As Gamepack_Main_Type )

	If Len ( Gamepack.Pack ) > 0 AndAlso Gamepack.Pack <> Gamepack_Data.Path Then
		
		Gamepack_Data.Path = Gamepack.Pack
	
	End If

	If Is_Dir ( Gamepack.Root & Gamepack_Data.Path & "\Assets" ) = 0 Then
		
		Gamepack_Data.Path = _constDefaultGamepack_

	End If
	
	Gamepack_Icon_Create ( Gamepack_Data )
	Gamepack_Selected_Create ( Gamepack_Data )

End Sub

Sub Gamepack_Icon_Create ( Gamepack_Data As Gamepack_Type )

	If Is_File ( Gamepack.Root & Gamepack_Data.Path & "\Assets\Icons\blank disk.png" ) Then
		
		Gamepack_Data.Icon = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack_Data.Path & "\Assets\Icons\blank disk.png" )

	Else

		Gamepack_Data.Icon = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & "_Engine_\Assets\Icons\blank disk.png" )
		
	End If
	
End Sub

Sub Gamepack_Selected_Create ( Gamepack_Data As Gamepack_Type )

	If Is_File ( Gamepack.Root & Gamepack_Data.Path & "\Assets\Sprites\interface\selected.png" ) Then
		
		Gamepack_Data.Hover = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack_Data.Path & "\Assets\Sprites\interface\selected.png" )

	Else

		Gamepack_Data.Hover = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & "_Engine_\Assets\Sprites\interface\selected.png" )
	
	End If

End Sub

Sub Multi_Gamepack_Menu_Destroy ( Gamepack_Data ( Any ) As Gamepack_Type )

	Dim As Long Index = 0

	If UBound( Gamepack_Data, 1 ) < 0 Then
		Erase Gamepack_Data
		ReDim Gamepack_Data ( -1 To -1 )
		Exit Sub
	End If
	
	For Index = UBound ( Gamepack_Data, 1 ) To LBound ( Gamepack_Data, 1 ) Step -1
		
		Gamepack_Data ( Index ) .Path = ""
		
		ImageDestroy2 ( Gamepack_Data ( Index ) .Icon )
		ImageDestroy2 ( Gamepack_Data ( Index ) .Hover )
		ImageDestroy2 ( Gamepack_Data ( Index ) .TrayItem )
		ImageDestroy2 ( Gamepack_Data ( Index ) .TraySelected )

		ReDim Preserve Gamepack_Data ( 0 To UBound ( Gamepack_Data, 1 ) - 1 )
	
	Next Index
	
	Erase Gamepack_Data
	ReDim Gamepack_Data ( -1 To -1 )

End Sub

Sub Multi_Gamepack_Menu_Create ( Gamepack_Data ( Any ) As Gamepack_Type )
	
	Dim As Long mIndex = -1, Index = 0, Entry = -1
	
	ReDim As String Gamepacks ( -1 To -1 )
		
	Cat ( Gamepacks ( ), _constIncPathStr_ & Gamepack.Root & "*", fbDirectory )
	
	Select Case UBound ( Gamepacks, 1 )
	Case -1
		
		Gamepack.Pack = _constDefaultGamepack_
		
		If Is_Dir ( _constIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets" ) <> 0 Then
			
			Redim Gamepacks ( 0 To 0 )
			
			Gamepacks ( 0 ) = Gamepack.Pack
			
			Exit Sub
			
		End If
		
	End Select
	
	Gamepacks_Prune ( Gamepacks ( ), Gamepack_Data ( ) )
		
End Sub

Sub Gamepacks_Prune ( Gamepacks ( Any ) As String, Gamepack_Data ( Any ) As Gamepack_Type )
	
	Dim As Long Index = 0, Entry = -1
	
	ReDim Preserve Gamepack_Data ( 0 To UBound ( Gamepacks, 1 ) )
		
	For Index = 0 To Ubound ( Gamepacks, 1 ) Step 1
		
		If Is_Dir ( Gamepack.Root & Gamepacks ( Index ) & "\Assets" ) Then
			
			Entry += 1

			ReDim Preserve Gamepack_Data ( 0 To Entry )
			
			Gamepack_Data ( Entry ) .Path = Gamepacks ( Index )
								
			If Is_File ( Gamepack.Root & Gamepack_Data ( Entry ) .Path & "\Assets\Icons\blank disk.png" ) Then
					
				Gamepack_Data ( Entry ) .Icon = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack_Data ( Entry ) .Path & "\Assets\Icons\blank disk.png" )

			End If
		
		End If
		
	Next Index

End Sub

Sub Gamepack_Render ( Gamepack_Data ( Any ) As Gamepack_Type )
	
	Dim As Long Index = 0
	
	Line ( 0, 0 ) - Step ( 640 - 1, 480 - 1 ), RGBA ( 0, 0, 0, 0 ), BF
		
	For Index = 0 To Ubound ( Gamepack_Data, 1 ) Step 1	

		Gamepack_Data ( Index ) .TrayItem = ImageCreate ( 256, 32, RGBA ( 0, 0, 0, 0 ), 32 )
		
		Gamepack_Data ( Index ) .TraySelected = ImageCreate ( 256, 32, RGBA ( 0, 0, 0, 0 ), 32 )
		
		Gamepack_Icon_Create ( GamePack_Data ( Index ) )
		
		Put Gamepack_Data ( Index ) .TrayItem, ( 0, Index * 32 ), Gamepack_Data ( Index ) .Icon, Alpha

		Gfx_Buffer_Text ( Gamepack_Data ( Index ) .TrayItem, Gamepack_Data ( Index ) .Path, 6, 3, 1, "Mishap22" )

		Put Gamepack_Data ( Index ) .TraySelected, ( 0, 0 ), Gamepack_Data ( Index ) .TrayItem, Alpha

		Put Gamepack_Data ( Index ) .TraySelected, ( 0, Index * 32 ), Gamepack_Data ( Index ) .Hover, Alpha
		
	Next Index

End Sub

Sub Multi_Gamepack_Create ( Gamepack_Data ( Any ) As Gamepack_Type )

	Dim As Long Index = 0
	
	For Index = 0 To Ubound ( Gamepack_Data, 1 ) Step 1
	
		Gamepack_Create ( Gamepack_Data ( Index ), Gamepack )

	Next Index

End Sub

Sub Gamepack_Menu ( Gamepack_Data ( Any ) As Gamepack_Type )
		
	Dim As Long Index = 0, mIndex = -1
	
	Line ( 0, 0 ) - Step ( 640 - 1, 480 - 1 ), RGBA ( 0, 0, 0, 0 ), BF
	
		Do
					
			For Index = 0 To Ubound ( Gamepack_Data, 1 ) Step 1	
				
				If Gamepack_Data ( Index ) .Path = Gamepack.Pack Then
					Put ( 0, Index * 32 ), Gamepack_Data ( Index ) .TraySelected, Alpha
					mIndex = Index
				Else
					Put ( 0, Index * 32 ), Gamepack_Data ( Index ) .TrayItem, Alpha
				End If
			
			Next Index
									
			Flip : KeyStroke = WaitKey ( )
		
			Select Case KeyStroke
			
			Case Chr ( 27 )
				
				Exit Sub
				
			Case Chr ( 13 )
				
				Select Case mIndex
				Case -1
				Case Else
					Gamepack.Pack = Gamepack_Data( mIndex ) .Path
					Exit Sub
				End Select
			
			Case Chr ( 255 ) & Chr ( 80 )
				
				mIndex += 1
			
			Case Chr ( 255 ) & Chr ( 72 )
				
				mIndex -= 1
			
			End Select

			Select Case mIndex
			Case Is > UBound ( Gamepack_Data, 1 )
				mIndex = LBound ( Gamepack_Data, 1 )
			End Select

			Select Case mIndex
			Case Is < LBound ( Gamepack_Data, 1 )
				mIndex = UBound ( Gamepack_Data, 1 )
			End Select
		
			Select Case mIndex
			Case LBound ( Gamepack_Data, 1 ) To UBound ( Gamepack_Data, 1 )
				'Put ( 0, mIndex * 32 ), GamePAck_Data ( mIndex ) .TraySelected, Alpha
			End Select
			
			Gamepack.Pack = Gamepack_Data ( mIndex ) .Path
				
		Loop
	
End Sub
